//=============================================================================
// DirectionFixedEx.js
//=============================================================================

var Imported = Imported || {};
Imported.DirectionFixedEx = true;

/*:
 * @plugindesc 移動ルートを設定しつつ向き固定 ON にしたい時に使用する
 * 
 * @help
 * ■概要
 * 移動ルートの設定で向き変更前後で向き固定 OFF-ON してもプレイヤの方を
 * 向いてしまう時があるので、強制的にプレイヤの方を向かないようにする。
 * 
 * ■メモ タグ
 * <CanTurnTowardPlayer: [true of false]>
 * プレイヤの方を向く事ができるかどうか
 * 設定しない場合は true
 *
 */
(function ()
{
    // プレイヤの方を向く
    Game_Event.prototype.turnTowardPlayer = function ()
    {
        var event = this.event();
        var condition = true;

        if (event.meta.CanTurnTowardPlayer)
        {
            condition = event.meta.CanTurnTowardPlayer.toLowerCase() == "true";
        }

        if (condition)
        {
            this.turnTowardCharacter($gamePlayer);
        }
    };
}());
